/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.util.Utilities;

public class MemoryChunk {
    public int addr;
    public int size;
    public MemoryChunk next;
    public MemoryChunk previous;

    public MemoryChunk(int addr, int size) {
        this.addr = addr;
        this.size = size;
    }

    public boolean isAvailable(int requestedSize, int addrAlignment) {
        if (requestedSize > this.size) {
            return false;
        }
        return Utilities.alignUp(this.addr, addrAlignment) + requestedSize <= this.addr + this.size;
    }

    public String toString() {
        return String.format("[addr=0x%08X-0x%08X, size=0x%X]", this.addr, this.addr + this.size, this.size);
    }
}

